﻿'Program: Mail Order Form
'Programmer: Justin Whitt - Lab 6
'Purpose: Add items together to generate saes tax shipping and handling and total amount due. 

Option Strict On
Option Explicit On
Public Class Form1
    Dim totalAmount As Double = 0
    Dim subTotal As Double = 0
    Dim totalWeight As Double = 0
    Const taxRateCa As Double = 0.08

    Private Sub btnAddItem_Click(sender As Object, e As EventArgs) Handles btnAddItem.Click
        Dim numOfItems As Double = 0
        Dim shipState As String = txtState.Text.Trim().ToLower()

        If txtItemName.Text = "" Or IsNumeric(txtItemName.Text) Then
            MessageBox.Show("Please enter an item name.")
            Return
        End If

        If txtQuantityDesired.Text = "" Or Not IsNumeric(txtQuantityDesired.Text) Then
            MessageBox.Show("Please enter a quantity desired in numeric form.")
            Return
        Else
            numOfItems = CInt(txtQuantityDesired.Text)
        End If

        If txtWeight.Text = "" Or Not IsNumeric(txtWeight.Text) Then
            MessageBox.Show("Please enter a weight in numeric form.")
            Return
        Else
            totalWeight += Math.Floor(CDbl(txtWeight.Text) * numOfItems)
        End If

        If txtPrice.Text = "" Or Not IsNumeric(txtPrice.Text) Then
            MessageBox.Show("Please enter the price as a numeric.")
            Return
        Else
            subTotal += CDbl(txtPrice.Text) * numOfItems
        End If

        If shipState = "" Or shipState.Length <> 2 Then
            MessageBox.Show("Please enter a state in two letter format.")
            Return
        Else
            txtState.Enabled = False
        End If

        txtItemName.Text = String.Empty
        txtQuantityDesired.Text = String.Empty
        txtWeight.Text = String.Empty
        txtPrice.Text = String.Empty
    End Sub

    Private Function CalculateSalesTax(subTotal As Double) As Double
        If txtState.Text.Trim().ToLower() = "ca" Then
            Return subTotal * taxRateCa
        Else
            Return 0
        End If
    End Function

    Private Function CalculateShipAndHand(totalWeight As Double) As Double
        Dim handCharge As Double = 0
        Dim shipCharge As Double = 0

        If totalWeight = 0 Then
            Return 0
        Else
            Select Case totalWeight
                Case < 10
                    handCharge = 1.0
                Case 10 To 100
                    handCharge = 3.0
                Case > 100
                    handCharge = 5.0
            End Select
        End If

        shipCharge = totalWeight * 0.25

        Return shipCharge + handCharge
    End Function

    Private Sub btnClearItem_Click(sender As Object, e As EventArgs) Handles btnClearItem.Click
        txtItemName.Text = String.Empty
        txtQuantityDesired.Text = String.Empty
        txtWeight.Text = String.Empty
        txtPrice.Text = String.Empty

        txtItemName.Focus()

    End Sub

    Private Sub btnNewOrder_Click(sender As Object, e As EventArgs) Handles btnNewOrder.Click
        Dim result As DialogResult = MessageBox.Show("Are you sure you want to start a new order?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question)


        If result = DialogResult.Yes Then
            btnClearItem_Click(sender, e)
            txtState.Text = String.Empty
            txtState.Enabled = True

            totalAmount = 0
            subTotal = 0
            totalWeight = 0

            lblSalesTax.Text = ""
            lblShipAndHand.Text = ""
            lblSubtotalAmuntDue.Text = ""
            lblTotalAmountDue.Text = ""
            MessageBox.Show("A new order has been started.")
        End If
    End Sub

    Private Sub btnCompleteOrder_Click(sender As Object, e As EventArgs) Handles btnCompleteOrder.Click
        If subTotal = 0 Then
            MessageBox.Show("Please add items to the order before completing it.")
            Return
        End If

        Dim salesTax As Double = CalculateSalesTax(subTotal)
        Dim shipAndHand As Double = CalculateShipAndHand(totalWeight)
        totalAmount = shipAndHand + salesTax + subTotal

        lblSalesTax.Text = salesTax.ToString("C2")
        lblShipAndHand.Text = shipAndHand.ToString("C2")
        lblSubtotalAmuntDue.Text = subTotal.ToString("C2")
        lblTotalAmountDue.Text = totalAmount.ToString("C2")

    End Sub

End Class
